(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    241607,       4172]
NotebookOptionsPosition[    240288,       4143]
NotebookOutlinePosition[    240683,       4159]
CellTagsIndexPosition[    240640,       4156]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Extremum-seeking control  (Problem 10.6)", "Section",
 CellChangeTimes->{{3.763043393923259*^9, 3.763043405080933*^9}, {
  3.76515493729681*^9, 3.7651549413626842`*^9}, {3.793909539232601*^9, 
  3.79390954336514*^9}},ExpressionUUID->"4bf8de4e-731a-47ff-8c0b-\
c8d779e41a92"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[1663]:=",ExpressionUUID->"5052279d-da40-49a7-a867-448938f2ac3a"],

Cell["\<\
Works but needs to use Cos, not Sin to prevent problem at t=0\
\>", "Text",
 CellChangeTimes->{{3.76304346257683*^9, 3.7630435082458572`*^9}, {
   3.76516435071117*^9, 3.7651643670299053`*^9}, {3.7651667095261707`*^9, 
   3.765166710660796*^9}, {3.7651985135749893`*^9, 3.7651985191027937`*^9}, {
   3.7651987946146793`*^9, 3.765198801846636*^9}, {3.765198933744795*^9, 
   3.765198934631843*^9}, {3.76519946844083*^9, 3.765199489015608*^9}, 
   3.765993676872357*^9},
 Background->GrayLevel[
  0.85],ExpressionUUID->"27954088-5fbe-4e92-b91d-f641d3cce72e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[Rule]", "50"}], ",", 
     RowBox[{"a", "\[Rule]", "0.2"}], ",", 
     RowBox[{"\[Omega]0", "\[Rule]", 
      RowBox[{"2", "\[Pi]", " ", "10"}]}], ",", 
     RowBox[{"\[Omega]h", "\[Rule]", 
      RowBox[{"2", "\[Pi]"}]}], " ", ",", 
     RowBox[{"j00", "\[Rule]", "7"}], ",", 
     RowBox[{"\[Theta]00", "\[Rule]", "5"}], ",", 
     RowBox[{"d0", "\[Rule]", "0"}], ",", 
     RowBox[{"\[Omega]d", "\[Rule]", 
      RowBox[{"2", "\[Pi]", " ", "0.03"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"j0", "[", 
    RowBox[{"\[Theta]_", ",", "\[Theta]0_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"j00", "+", 
     RowBox[{
      FractionBox["1", "2"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Theta]", "-", "\[Theta]0"}], ")"}], "2"]}]}], "/.", 
    "pars"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]0", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Theta]00", "+", 
     RowBox[{"d0", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Omega]d", " ", "t"}], "]"}]}]}], "/.", "pars"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqs", "=", 
    RowBox[{"{", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[Theta]h", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", "k"}], " ", "a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Omega]0", " ", "t"}], "]"}], 
        RowBox[{"\[Eta]", "[", "t", "]"}]}]}], ",", " ", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Eta]", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", " ", "\[Omega]h"}], " ", 
         RowBox[{"\[Eta]", "[", "t", "]"}]}], "+", " ", 
        RowBox[{
         RowBox[{"j", "'"}], "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
      "\t", 
      RowBox[{
       RowBox[{"j", "[", "t", "]"}], "\[Equal]", " ", 
       RowBox[{"j0", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]h", "[", "t", "]"}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"\[Omega]0", " ", "t"}], "]"}]}]}], ",", 
         RowBox[{"\[Theta]0", "[", "t", "]"}]}], "]"}]}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"init", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]h", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"\[Eta]", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]hs", ",", "\[Eta]s", ",", "js"}], "}"}], "=", 
   RowBox[{"NDSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"eqs", "/.", "pars"}], ",", "init"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]h", ",", "\[Eta]", ",", "j"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"js", "[", "t", "]"}], ",", 
     RowBox[{"\[Theta]hs", "[", "t", "]"}], ",", 
     RowBox[{"\[Theta]0", "[", "t", "]"}], ",", 
     RowBox[{
      RowBox[{"j0", "[", 
       RowBox[{"\[Theta]00", ",", "\[Theta]00"}], "]"}], "/.", "pars"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "15"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Black", ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Dashed", ",", "Thin"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Dashed", ",", "Thin"}], "}"}]}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.765202538919991*^9, 3.765202543512578*^9}, {
   3.76520268543118*^9, 3.765202688476325*^9}, {3.7652028115828447`*^9, 
   3.765202844565233*^9}, {3.765202890537538*^9, 3.765202907376872*^9}, {
   3.765203045733099*^9, 3.765203087458324*^9}, {3.765203157343112*^9, 
   3.765203204752314*^9}, 3.765203695361456*^9, 3.7652038516228456`*^9, {
   3.765204815239416*^9, 3.7652049271872473`*^9}, {3.765204963332942*^9, 
   3.765204971386568*^9}, {3.765205013695965*^9, 3.765205078228146*^9}, {
   3.765206246925543*^9, 3.765206254891815*^9}, {3.765226799945806*^9, 
   3.7652268338336773`*^9}, {3.765226972320993*^9, 3.765227037444461*^9}, {
   3.765247647857555*^9, 3.7652476618297586`*^9}, {3.765247929833888*^9, 
   3.765247936821499*^9}, {3.765991394496829*^9, 3.7659914568763103`*^9}, 
   3.7659914919381638`*^9, {3.7659916162123833`*^9, 3.765991646617674*^9}, {
   3.765991774314787*^9, 3.765991798606415*^9}, {3.765992035947043*^9, 
   3.765992041401369*^9}, {3.7659920902371397`*^9, 3.7659921157036333`*^9}, {
   3.765992158590643*^9, 3.765992164678154*^9}, {3.765992197408888*^9, 
   3.765992197485166*^9}, {3.7659935043287992`*^9, 3.7659935045977163`*^9}, {
   3.7659935558717403`*^9, 3.765993555956502*^9}, {3.765993708466838*^9, 
   3.765993731334877*^9}, {3.765993767121174*^9, 3.765993782701256*^9}, {
   3.765993862326619*^9, 3.76599389078584*^9}, {3.765993926180685*^9, 
   3.765993942508107*^9}, {3.765994002962887*^9, 3.765994040790971*^9}},
 CellLabel->
  "In[1664]:=",ExpressionUUID->"9e3b51c8-074d-4a37-b619-58aab7b5c1cb"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwBEQPu/CFib1JlAgAAADAAAAACAAAApsZRiwgByT8AAAAAAAAuQOR9Yptx
Nck/8RGSmiikLUDOjcJcXVPJP8YPD90hbi1AuJ0iHklxyT++QweKwjctQIu9
4qAgrck/hWP5O67KLEB0zUJiDMvJP9xCNUVclCxAXt2iI/joyT8OfD82d14s
QDL9YqbPJMo/wcFgp9r0K0AcDcNnu0LKP4yJ3uCbwStABh0jKadgyj8Q7Upk
uo8rQNk846t+nMo/Frt1FAwxK0DCTENtarrKP1WMARi9BCtArFyjLlbYyj9Z
v8fGxdoqQIB8Y7EtFMs/RS1obcmOKkBqjMNyGTLLP3d+KiAzbSpAVJwjNAVQ
yz9RHafJ0E4qQD6sg/Xwbcs/HOmuVNAzKkAnvOO23IvLP8NkqgBbHCpAEMxD
eMipyz/EKVXxlAgqQPrbozm0x8s/JPtaypz4KUDk6wP7n+XLPy/lh1yL7ClA
zvtjvIsDzD8LeHRac+QpQLgLxH13Icw/xI4hFWHgKUCiGyQ/Yz/MP/FDbz9a
4ClAjCuEAE9dzD/R/d/EXeQpQHU75ME6e8w/+4pjp2PsKUBeS0SDJpnMP8Fz
G+Zc+ClASFukRBK3zD/AHdZrMwgqQDJrBAb+1Mw/0L1AFMobKkAce2TH6fLM
P5d9isH8MipABovEiNUQzT9Ws3eBoE0qQPCaJErBLs0/Zs3pw4NrKkDaqoQL
rUzNP+AheKxujCpAw7rkzJhqzT82PZOBI7AqQKzKRI6EiM0/G4jyMF/WKkCW
2qRPcKbNP7a1buzZ/ipAavpk0kfizT9D1MMEWlUrQFQKxZMzAM4/yHXwAb+C
K0A9GiVVHx7OP+SQkx4ksStAEDrl1/ZZzj+46UTZog8sQLd5Zd2l0c4/URIK
JbfKLECmPmvXGvLOP4OI9/kk+yxAlgNx0Y8Szz/G2lBq/CktQIbIdssEM88/
o5faD/lWLUB2jXzFeVPPP5UmkTjfgS1AZlKCv+5zzz+ZFWsWfKotQFYXiLlj
lM8/snkNwKXQLUDcDwIsRcHPPwAAAAAAAC5AF6JgxA==
       "]], 
      LineBox[CompressedData["
1:eJwcV3k81d/z1qa0IEql7n7tSyhCZSaRQqGkKBQRSaFUH5WlaEGKhJJSoagk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       "]]},
     Annotation[#, "Charting`Private`Tag$605320#1"]& ], 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwsV3c81f/3t697XYWQKEXSQELJiPOyEpllJStS6kNJEpKVSmQXURJJKZSR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       "]]},
     Annotation[#, "Charting`Private`Tag$605320#2"]& ], 
    TagBox[
     {GrayLevel[0], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/cM7b25AfoEdAxiIOOQvKDvprzbPHsY/2NOz21dt
HZzPylbE/jJrP5zvWZ/YujXsOJy/vTL17tKL5+D8m1HZ+kXll+F8QffetIMO
1+F8gSupm8yjb8P5ygo5K1uT7sP5FndzTztOeohwz68GnyuzH8P5GftPnNjX
9BTOn5m8XEo04Tmcrxvx8Nu/1Jdw/r3P/uccPF/D+Z/uSxqIhb6F8yesrkoP
D38P56vxc/hWzP4A528raFjdN/8jnH9FdTJ74KRPcL5K82WN2Jmf4XzLgPsm
82d/gfPvFrTa9fZ8hfM3WUbyHp34Dc4XCzt+c0Xrdzjf/hHDxEMlPxD+E8vg
Vav4Cec3zctsN836BefPPTfjWF/Bbzi/Nm/yB9miP3D+60QNicikv3B+999X
LPfS/sH5u964v+eL+g/nX1O1eGSlwuAAD2/NZP3JSxH8g2HR1Y5yjHC+ccSr
lSILEfycZrfrttJMcH5HGscvxskI/l7ZxP+vRJjh/J3/2pi1+hD8c5udX/UK
ssD5RxXSjvVMQvBbtocufMjFCufHKN2Ji+5F8H9v05fWZmeD82uYX56ZWofg
i6lYJqoysMP55XlhX7gqEXyRZP6y1j0I/sbwE9///0fwASpG0ek=
       "]]},
     Annotation[#, "Charting`Private`Tag$605320#3"]& ], 
    TagBox[
     {GrayLevel[0], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/cM7b25AfoEdAxjIOOQvKDvprzbPHsY/2NOz21dt
HZzPylbE/jJrP5zvWZ/YujXsOJy/vTL17tKL5+D8m1HZ+kXll+F8QffetIMO
1+F8gSupm8yjb8P5ygo5K1uT7sP5FndzTztOeohwz68GnyuzH8P5GftPnNjX
9BTOn5m8XEo04Tmcrxvx8Nu/1Jdw/r3P/uccPF/D+Z/uSxqIhb6F8yesrkoP
D38P56vxc/hWzP4A528raFjdN/8jnH9FdTJ74KRPcL5K82WN2Jmf4XzLgPsm
82d/gfPvFrTa9fZ8hfM3WUbyHp34Dc4XCzt+c0Xrdzjf/hHDxEMlPxD+E8vg
Vav4Cec3zctsN836BefPPTfjWF/Bbzi/Nm/yB9miP3D+60QNicikv3B+999X
LPfS/sH5u964v+eL+g/nX1O1eGSlwuAAD2/NZP3JSxH8g2HR1Y5yjHC+ccSr
lSILEfycZrfrttJMcH5HGscvxskI/l7ZxP+vRJjh/J3/2pi1+hD8c5udX/UK
ssD5RxXSjvVMQvBbtocufMjFCufHKN2Ji+5F8H9v05fWZmeD82uYX56ZWofg
i6lYJqoysMP55XlhX7gqEXyRZP6y1j0I/sbwE9///0fwAcSk04k=
       "]]},
     Annotation[#, "Charting`Private`Tag$605320#4"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 2.99999993877551}, {0, 15}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.765992165586585*^9, 3.7659921991217337`*^9, 3.765993505369425*^9, 
   3.7659935566921787`*^9, {3.765993689780971*^9, 3.765993736558704*^9}, {
   3.765993768463749*^9, 3.765993783338286*^9}, {3.7659938631568403`*^9, 
   3.765993891499633*^9}, {3.7659939267765627`*^9, 3.765993943275207*^9}, {
   3.765994003755*^9, 3.765994041395606*^9}, 3.76599914729245*^9, 
   3.7939095712709293`*^9, 3.823226922050906*^9},
 CellLabel->
  "Out[1672]=",ExpressionUUID->"df4d712b-b733-48e2-956b-bd43897a94e4"]
}, Open  ]],

Cell["add periodic disturbance in \[Theta][t]", "Text",
 CellChangeTimes->{{3.76304346257683*^9, 3.7630435082458572`*^9}, {
  3.76516435071117*^9, 3.7651643670299053`*^9}, {3.7651667095261707`*^9, 
  3.765166710660796*^9}, {3.7651985135749893`*^9, 3.7651985191027937`*^9}, {
  3.7651987946146793`*^9, 3.765198801846636*^9}, {3.765198933744795*^9, 
  3.765198934631843*^9}, {3.76519946844083*^9, 3.765199489015608*^9}, {
  3.765202360267654*^9, 3.765202367707197*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"33f1c53d-da4a-4611-8208-e821a21b8940"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pars", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"k", "\[Rule]", "50"}], ",", 
     RowBox[{"a", "\[Rule]", "0.2"}], ",", 
     RowBox[{"\[Omega]0", "\[Rule]", 
      RowBox[{"2", "\[Pi]", " ", "10"}]}], ",", 
     RowBox[{"\[Omega]h", "\[Rule]", 
      RowBox[{"2", "\[Pi]"}]}], " ", ",", 
     RowBox[{"j00", "\[Rule]", "7"}], ",", 
     RowBox[{"\[Theta]00", "\[Rule]", "5"}], ",", 
     RowBox[{"d0", "\[Rule]", "1"}], ",", 
     RowBox[{"\[Omega]d", "\[Rule]", 
      RowBox[{"2", "\[Pi]", " ", "0.1"}]}]}], " ", "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"j0", "[", 
    RowBox[{"\[Theta]_", ",", "\[Theta]0_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"j00", "+", 
     RowBox[{
      FractionBox["1", "2"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Theta]", "-", "\[Theta]0"}], ")"}], "2"]}]}], "/.", 
    "pars"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]0", "[", "t_", "]"}], ":=", 
   RowBox[{
    RowBox[{"\[Theta]00", "+", 
     RowBox[{"d0", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"\[Omega]d", " ", "t"}], "]"}]}]}], "/.", "pars"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eqs", "=", 
    RowBox[{"{", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[Theta]h", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", "k"}], " ", "a", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"\[Omega]0", " ", "t"}], "]"}], 
        RowBox[{"\[Eta]", "[", "t", "]"}]}]}], ",", " ", 
      "\[IndentingNewLine]", "\t", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Eta]", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", " ", "\[Omega]h"}], " ", 
         RowBox[{"\[Eta]", "[", "t", "]"}]}], "+", " ", 
        RowBox[{
         RowBox[{"j", "'"}], "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
      "\t", 
      RowBox[{
       RowBox[{"j", "[", "t", "]"}], "\[Equal]", " ", 
       RowBox[{"j0", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"\[Theta]h", "[", "t", "]"}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"\[Omega]0", " ", "t"}], "]"}]}]}], ",", 
         RowBox[{"\[Theta]0", "[", "t", "]"}]}], "]"}]}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"init", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]h", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"\[Eta]", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", "=", "15"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]hs", ",", "\[Eta]s", ",", "js"}], "}"}], "=", 
   RowBox[{"NDSolveValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"eqs", "/.", "pars"}], ",", "init"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]h", ",", "\[Eta]", ",", "j"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"js", "[", "t", "]"}], ",", 
     RowBox[{"\[Theta]hs", "[", "t", "]"}], ",", 
     RowBox[{"\[Theta]0", "[", "t", "]"}], ",", 
     RowBox[{
      RowBox[{"j0", "[", 
       RowBox[{"\[Theta]00", ",", "\[Theta]00"}], "]"}], "/.", "pars"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "15"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Black", ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Dashed", ",", "Thin"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Dashed", ",", "Thin"}], "}"}]}], "}"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.765164377890422*^9, 3.765164395229397*^9}, {
   3.7651651108637257`*^9, 3.765165362912959*^9}, {3.765165416438322*^9, 
   3.7651654169250402`*^9}, 3.7651670810987453`*^9, 3.765167159323331*^9, {
   3.765167460695685*^9, 3.765167478656201*^9}, {3.7651675196295223`*^9, 
   3.7651675479776707`*^9}, {3.765167830358502*^9, 3.765167953649726*^9}, {
   3.7651681289265537`*^9, 3.7651681942572393`*^9}, 3.7651688212244062`*^9, {
   3.765168952253194*^9, 3.765168984014913*^9}, {3.765198557361784*^9, 
   3.7651985916694527`*^9}, {3.7651987611311607`*^9, 3.7651987707784*^9}, {
   3.765198810650474*^9, 3.765198910793894*^9}, {3.765198980228188*^9, 
   3.765199101448197*^9}, {3.765199141872405*^9, 3.765199456049925*^9}, {
   3.7651995139719057`*^9, 3.765199737266755*^9}, {3.7651997958338346`*^9, 
   3.765199873019374*^9}, {3.765199903312942*^9, 3.765199904133284*^9}, {
   3.7652022562257643`*^9, 3.7652022868436823`*^9}, {3.765202318243325*^9, 
   3.765202337708849*^9}, {3.765202379945735*^9, 3.7652024378945017`*^9}, {
   3.765202469880704*^9, 3.76520251734842*^9}, {3.765202563667596*^9, 
   3.7652026000172873`*^9}, {3.765202650394206*^9, 3.7652026733691597`*^9}, {
   3.765203125091632*^9, 3.7652031332798843`*^9}, {3.765203212526561*^9, 
   3.76520321780062*^9}, {3.765204949393849*^9, 3.7652049494624023`*^9}, {
   3.765205087315435*^9, 3.7652050922667303`*^9}, {3.765206167064187*^9, 
   3.765206174144903*^9}, {3.765206205980578*^9, 3.76520622882027*^9}, {
   3.765226816262178*^9, 3.765226821947147*^9}, {3.7652457595435123`*^9, 
   3.765245813891221*^9}, 3.7652476798256617`*^9, {3.765247711998108*^9, 
   3.765247834651135*^9}, {3.76524819924262*^9, 3.765248208320107*^9}, {
   3.7659914762313747`*^9, 3.765991518685604*^9}, {3.7659915547123337`*^9, 
   3.765991563068948*^9}, {3.765991659368094*^9, 3.7659916685277567`*^9}, 
   3.7659917020201197`*^9, {3.765991817853649*^9, 3.765991873222224*^9}, {
   3.765991928790992*^9, 3.765991970182043*^9}, {3.765992003418227*^9, 
   3.76599201327137*^9}, 3.7659920503251867`*^9, {3.765992175222681*^9, 
   3.765992190584331*^9}, {3.765992773587406*^9, 3.765992791637094*^9}, {
   3.765993055121765*^9, 3.765993058786337*^9}, 3.765993174564274*^9, {
   3.765993242439205*^9, 3.7659932989196243`*^9}, {3.7659933425658207`*^9, 
   3.7659933965409603`*^9}, {3.765993562519536*^9, 3.765993632917391*^9}, {
   3.765999091536819*^9, 3.7659990951888943`*^9}},
 CellLabel->
  "In[1673]:=",ExpressionUUID->"3296cf37-04ee-43bc-91f7-62cb08f4f377"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwcWnk4lG8XtpR9GWNmiJmx70spheL3HIoKIVuySxTKUlIke4WolCJJyRoR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       "]], 
      LineBox[{{0.19970283352871362`, 15.}, {0.20242066430404754`, 
       14.70986985390245}, {0.20702112698999298`, 14.252166169659878`}, {
       0.2116215896759384, 13.88444804189944}, {0.2162220523618838, 
       13.661127891832807`}, {0.22082251504782924`, 13.619637119775822`}, {
       0.22542297773377468`, 13.768603321266292`}, {0.2300234404197201, 
       14.081948442675282`}, {0.2346239031056655, 14.501544682993808`}, {
       0.23922436579161094`, 14.950970414993538`}, {0.23977927189420548`, 
       15.}}]},
     Annotation[#, "Charting`Private`Tag$605416#1"]& ], 
    TagBox[
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwU2nc81d8bAHB7u+697r1khcQ3pJJCqfNQFCkqlE1CRjbJJiWlQSIjSRlJ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       "]]},
     Annotation[#, "Charting`Private`Tag$605416#2"]& ], 
    TagBox[
     {GrayLevel[0], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}], 
      LineBox[CompressedData["
1:eJwt2nk4VN8bAHDL2BINxlzbjH3MDEMLss+rsktFFCEpkiWUKMmWhCRSiUqy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       "]]},
     Annotation[#, "Charting`Private`Tag$605416#3"]& ], 
    TagBox[
     {GrayLevel[0], Thickness[Tiny], Opacity[1.], Dashing[{Small, Small}], 
      LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ/e3eySMq3VPsGMBAxsFN5dXdj9cP2cP4P6+bT/1w
/RKcf9h5+ZKLix7D+TL3dz5L0nkL54vkxK9id/4M508ydNvtF/oDzr85w+DA
R4G/cH73kvrzTJKMDjC++JTHnZPnMsP57SGedpe+scL5xZYL4082ccD5Lu9/
VeU95oLzG20CE6UseOF8q3Uzt9Tt54fzc358bDjBKwjn/9QWuKcbKgTn26xe
s2DaNGE4/6OQV0LYIRE4/0lPQlgRuxic7/m+3POpmTic/yaZo3hLvQSc76Yi
ztR+SBLOFzqr1rfhvRScL9OxPsDMTAbOn6FtKSCcLgvnn5JyNP08UQ7hH5lD
E/SvycP5fMyLShKbFOB8uUZ5m0g1RTifUzVmW9BxBF/PVnJ9eawSnF90T+iw
F4MynP/+c0+o5wwE313/2CxPXRU4f99n69/fzyH4eTpGty6mqsL5tu9SrkRy
qsH5rioSvryLEHyNhq6KQ+bqcL5WquV+1VsIfuq+jJYthRpw/v4FV1I+imrC
+V9W/P+uvx3BT1ZdzTnLVwvO/6g12WzTBwR/x5LfD792aMP5US7KDtZyOnC+
dG77Tr0DCL4oV85G33BdOP+W9eTLy1Yj+PNyd339/x/BBwCm/MYf
       "]]},
     Annotation[#, "Charting`Private`Tag$605416#4"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Background->GrayLevel[0.97],
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 14.999999693877552`}, {-1, 15}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.765991565173627*^9, {3.765991665832304*^9, 3.765991670185706*^9}, 
   3.765991704326428*^9, {3.765991818720603*^9, 3.7659918748227177`*^9}, 
   3.765991974244729*^9, 3.7659920154734373`*^9, 3.765992052109295*^9, {
   3.765992181275038*^9, 3.7659922037093267`*^9}, {3.765992775477317*^9, 
   3.7659927933420362`*^9}, 3.765993060858061*^9, 3.765993177580613*^9, {
   3.765993248329461*^9, 3.765993300895117*^9}, {3.7659933446668043`*^9, 
   3.765993398486136*^9}, {3.765993564504219*^9, 3.765993633767254*^9}, 
   3.7659936902991734`*^9, {3.7659990927759047`*^9, 3.765999095978943*^9}, 
   3.765999302961555*^9, 3.793909571532086*^9, 3.823226922290954*^9},
 CellLabel->
  "Out[1681]=",ExpressionUUID->"65f1855a-2f96-4931-bd96-f1ba9fc4e393"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.76304346257683*^9, 3.7630435082458572`*^9}, {
  3.76516435071117*^9, 3.7651643670299053`*^9}, {3.7651667095261707`*^9, 
  3.765166710660796*^9}, {3.7651985135749893`*^9, 3.7651985191027937`*^9}, {
  3.7651987946146793`*^9, 3.765198801846636*^9}, {3.765198933744795*^9, 
  3.765198934631843*^9}, {3.76519946844083*^9, 3.765199489015608*^9}, {
  3.765202360267654*^9, 3.765202367707197*^9}, {3.76522514546452*^9, 
  3.76522514696761*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"ce29032d-1ad7-4166-b386-c2889d061ebd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dt", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Through", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"js", ",", "\[Theta]hs"}], "}"}], "[", "t", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tmax", ",", "dt"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<extremumSeekPlot.dat\>\"", ",", "dat"}], "]"}], ";"}], " ", 
   "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.765225307637471*^9, 3.7652253845880938`*^9}, {
  3.765225956896019*^9, 3.765225965276997*^9}, {3.7652267817385397`*^9, 
  3.765226784819187*^9}, {3.76522686588046*^9, 3.7652268729919233`*^9}, {
  3.765244259882051*^9, 3.7652442620286694`*^9}, {3.765247859371234*^9, 
  3.765247861161665*^9}, {3.765940358160266*^9, 3.765940360426484*^9}, {
  3.7659991533663054`*^9, 3.765999155465468*^9}, {3.7939095528866653`*^9, 
  3.793909567324637*^9}},
 CellLabel->
  "In[1682]:=",ExpressionUUID->"ec822a20-244e-4ee9-a7b4-fb746578714a"]
}, Open  ]]
},
WindowSize->{808, 598},
WindowMargins->{{Automatic, 4}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"74b4ed45-1dd5-45e7-8df2-3a391553e277"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 280, 4, 67, "Section",ExpressionUUID->"4bf8de4e-731a-47ff-8c0b-c8d779e41a92"],
Cell[863, 28, 175, 4, 30, "Input",ExpressionUUID->"5052279d-da40-49a7-a867-448938f2ac3a"],
Cell[1041, 34, 566, 10, 51, "Text",ExpressionUUID->"27954088-5fbe-4e92-b91d-f641d3cce72e"],
Cell[CellGroupData[{
Cell[1632, 48, 5657, 146, 300, "Input",ExpressionUUID->"9e3b51c8-074d-4a37-b619-58aab7b5c1cb"],
Cell[7292, 196, 104454, 1740, 252, "Output",ExpressionUUID->"df4d712b-b733-48e2-956b-bd43897a94e4"]
}, Open  ]],
Cell[111761, 1939, 555, 8, 51, "Text",ExpressionUUID->"33f1c53d-da4a-4611-8208-e821a21b8940"],
Cell[CellGroupData[{
Cell[112341, 1951, 6637, 160, 300, "Input",ExpressionUUID->"3296cf37-04ee-43bc-91f7-62cb08f4f377"],
Cell[118981, 2113, 119380, 1982, 244, "Output",ExpressionUUID->"65f1855a-2f96-4931-bd96-f1ba9fc4e393"]
}, Open  ]],
Cell[238376, 4098, 574, 9, 51, "Text",ExpressionUUID->"ce29032d-1ad7-4166-b386-c2889d061ebd"],
Cell[238953, 4109, 1319, 31, 191, "Input",ExpressionUUID->"ec822a20-244e-4ee9-a7b4-fb746578714a"]
}, Open  ]]
}
]
*)

