(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    474516,       8287]
NotebookOptionsPosition[    472443,       8247]
NotebookOutlinePosition[    472840,       8263]
CellTagsIndexPosition[    472797,       8260]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["adaptive control of unstable 1st-order system (Figure 10.1)", "Section",
 CellChangeTimes->{{3.575394492224346*^9, 3.575394511447494*^9}, 
   3.57557421634114*^9, {3.741724882876411*^9, 3.7417248894828863`*^9}, {
   3.74204214327542*^9, 3.74204214359566*^9}, {3.793911944659153*^9, 
   3.7939119480148697`*^9}},ExpressionUUID->"604c3724-e633-4cc6-b5f4-\
3295cb90fe06"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}],
  FontSize->12]], "Input",
 CellChangeTimes->{{3.5754278976868362`*^9, 3.575428102907278*^9}, 
   3.575490446670248*^9, {3.575490481529285*^9, 3.575490554547845*^9}, 
   3.575574216342483*^9, {3.741643689699143*^9, 3.7416436985116262`*^9}, {
   3.741697339168312*^9, 3.7416973397226*^9}},
 CellLabel->
  "In[1583]:=",ExpressionUUID->"caf69fce-de33-4573-a446-2f26e494af5b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"adapt", "[", 
   RowBox[{
   "\[Gamma]_", ",", "x0_", ",", "\[Tau]_", ",", "k0_", ",", "\[Alpha]_", ",",
     "ad_", ",", "\[Omega]d_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "eqs", ",", "init", ",", "pars", ",", "x", ",", "t", ",", "a", ",", "u", 
      ",", "j", ",", "k"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"eqs", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "'"}], "[", "t", "]"}], "-", " ", 
          RowBox[{"a", " ", 
           RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", 
         RowBox[{
          RowBox[{"u", "[", "t", "]"}], "+", 
          RowBox[{"ad", " ", 
           RowBox[{"UnitStep", "[", 
            RowBox[{"t", "-", "10"}], "]"}], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"\[Omega]d", " ", "t"}], "]"}]}]}]}], ",", 
        RowBox[{
         RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"k", "[", "t", "]"}]}], 
          RowBox[{"x", "[", 
           RowBox[{"t", "-", "\[Tau]"}], "]"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"k", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"\[Gamma]", " ", 
           SuperscriptBox[
            RowBox[{"x", "[", "t", "]"}], "2"]}], "-", 
          RowBox[{"\[Alpha]", " ", 
           RowBox[{"k", "[", "t", "]"}]}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"j", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          FractionBox["1", "2"], 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"x", "[", "t", "]"}], "2"], "+", 
            SuperscriptBox[
             RowBox[{"u", "[", "t", "]"}], "2"]}], ")"}]}]}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"init", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"t", " ", "/;", " ", 
           RowBox[{"t", " ", "\[LessEqual]", " ", "0"}]}], "]"}], "\[Equal]", 
         "x0"}], " ", ",", 
        RowBox[{
         RowBox[{"k", "[", 
          RowBox[{"t", " ", "/;", " ", 
           RowBox[{"t", " ", "\[LessEqual]", " ", "0"}]}], "]"}], "\[Equal]", 
         "k0"}], ",", 
        RowBox[{
         RowBox[{"j", "[", "0", " ", "]"}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", " ", "/;", " ", 
           RowBox[{"t", " ", "\[LessEqual]", " ", "0"}]}], "]"}], "\[Equal]", 
         
         RowBox[{
          RowBox[{"-", 
           RowBox[{"k", "[", 
            RowBox[{"t", " ", "/;", " ", 
             RowBox[{"t", " ", "\[LessEqual]", " ", "0"}]}], "]"}]}], 
          RowBox[{"x", "[", 
           RowBox[{"t", " ", "/;", " ", 
            RowBox[{"t", " ", "\[LessEqual]", " ", "0"}]}], "]"}]}]}]}], 
       "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"NDSolveValue", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"eqs", ",", "init"}], "}"}], "/.", 
         RowBox[{"a", "\[Rule]", "1"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"x", ",", "u", ",", "k", ",", "j"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
        RowBox[{"MaxSteps", "\[Rule]", 
         SuperscriptBox["10", "5"]}]}], 
       StyleBox["]",
        FontSize->12]}], 
      StyleBox["//",
       FontSize->12], 
      StyleBox["Quiet",
       FontSize->12]}]}]}], 
   StyleBox["]",
    FontSize->12]}]}]], "Input",
 CellChangeTimes->{{3.742042158486438*^9, 3.742042192637588*^9}, {
   3.742044052559888*^9, 3.742044099184702*^9}, {3.742044136306033*^9, 
   3.742044164959683*^9}, 3.7420442907820263`*^9, {3.742044523845582*^9, 
   3.7420445557108183`*^9}, {3.742044593668075*^9, 3.7420446305059137`*^9}, {
   3.742044970686171*^9, 3.742045016268483*^9}, {3.742045083581049*^9, 
   3.7420452095073547`*^9}, {3.742045579700128*^9, 3.7420455908310423`*^9}, {
   3.742045820352079*^9, 3.74204586301747*^9}, {3.7420458940510893`*^9, 
   3.742045903685487*^9}, {3.742045940191835*^9, 3.742046082307349*^9}, {
   3.742058210621978*^9, 3.7420582214600677`*^9}, {3.742058481690487*^9, 
   3.7420585511293993`*^9}, {3.742065000163178*^9, 3.74206503904221*^9}, {
   3.742065087751505*^9, 3.742065201605289*^9}, {3.742065236630728*^9, 
   3.742065397859683*^9}, {3.742065437864861*^9, 3.742065438117745*^9}, {
   3.74206717579587*^9, 3.7420671972370358`*^9}, {3.742067356451009*^9, 
   3.742067373533902*^9}, {3.742581886740528*^9, 3.742581903847746*^9}, {
   3.742997948829204*^9, 3.742997983286282*^9}, {3.7430041169103527`*^9, 
   3.7430042930060787`*^9}, {3.743004326502245*^9, 3.74300454915392*^9}, {
   3.743005155223673*^9, 3.743005271952015*^9}, {3.743005320933979*^9, 
   3.743005370409032*^9}, {3.7430054066282187`*^9, 3.743005406944257*^9}, 
   3.743005442010131*^9, 3.7430116715945387`*^9, {3.743012289456601*^9, 
   3.743012327136857*^9}, {3.743012414530911*^9, 3.743012745705261*^9}, {
   3.743012782871567*^9, 3.743012800925105*^9}, {3.743016904169107*^9, 
   3.743017158386056*^9}, {3.743017189454549*^9, 3.7430172053426037`*^9}, {
   3.743091861913694*^9, 3.7430918859490957`*^9}, {3.743091929498083*^9, 
   3.743092036040245*^9}, {3.7430920679367933`*^9, 3.743092121534171*^9}, {
   3.743092164188921*^9, 3.743092211040501*^9}, {3.7430922705370493`*^9, 
   3.743092307954603*^9}, {3.743092404012517*^9, 3.7430924101732473`*^9}, {
   3.743092567529374*^9, 3.743092583304531*^9}, {3.743092613610669*^9, 
   3.743092614742885*^9}, 3.743093237193883*^9, {3.743093325751504*^9, 
   3.7430933795655117`*^9}, {3.743093596890892*^9, 3.743093607904448*^9}, {
   3.74309411148323*^9, 3.7430941510496283`*^9}, 3.743094244091557*^9, {
   3.7430943620415783`*^9, 3.743094364013523*^9}, {3.743159961902759*^9, 
   3.743159962168118*^9}},
 CellLabel->
  "In[1584]:=",ExpressionUUID->"741900a0-4539-4cfe-80d4-02beba69b755"],

Cell[TextData[{
 "An adaptive gain will stabilize the system, no matter what the value of ",
 StyleBox["a",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.743093029669278*^9, 3.7430930877189693`*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"c1be2ade-6158-4e4b-9335-f68d2d37c9ed"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tend", "=", "10"}], ";", 
  RowBox[{"\[Gamma]", "=", "1"}], ";", " ", 
  RowBox[{"x0", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xs", ",", "us", ",", "ks", ",", "js"}], "}"}], "=", 
    RowBox[{"adapt", "[", 
     RowBox[{
     "\[Gamma]", ",", "x0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0"}], "]"}]}], ";", 
   RowBox[{"p1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"xs", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<x(t)\>\""}]}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"us", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<u(t)\>\""}]}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"ks", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "Automatic"}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "\"\<k(t)\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p4", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"js", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<j(t)\>\""}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2", ",", "p3", ",", "p4"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.743092023483*^9, {3.743092071639634*^9, 3.7430921138493967`*^9}, {
   3.743092175837195*^9, 3.743092176224987*^9}, {3.7430922148662663`*^9, 
   3.743092229995605*^9}, {3.743092296055038*^9, 3.743092323086363*^9}, {
   3.743092415726077*^9, 3.743092512958544*^9}, {3.743093626307787*^9, 
   3.7430936370111923`*^9}, {3.743094159336672*^9, 3.743094215173142*^9}, {
   3.7430942507549057`*^9, 3.743094309824459*^9}, 3.74309435257885*^9, {
   3.743096855611814*^9, 3.7430969037798433`*^9}, {3.743160239877968*^9, 
   3.743160255616782*^9}, {3.743160400143155*^9, 3.7431604003970213`*^9}},
 CellLabel->
  "In[1585]:=",ExpressionUUID->"5d075a28-8aba-47de-86ac-a3ab2226b805"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVl3c8Ft4Xx43I3ns+QxSSUZLqOQeRpOxRIVFGRplJtCiEjGSVkSgjSksk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           "]]},
         Annotation[#, "Charting`Private`Tag$599024#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.153061224489797`, 1.4999999999999432`}, {17., 
       20.500000000000014`}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox["\"x(t)\"", TraditionalForm],
      PlotRange->{{0., 9.999999795918367}, {-1, 2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {71.69210997123014, -57.159653520352826},
      ImageScaled[{0.5, 0.5}], {133.14109556274667, 108.87553051495776}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVl3c41t8bxx8zK3tvHitEm5bPbSRJlBCiZKYkCslIiUiUpKxkz6bRID33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           "]]},
         Annotation[#, "Charting`Private`Tag$599070#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{7.989795918367348, 1.5}, {17., 20.500000000000014`}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox["\"u(t)\"", TraditionalForm],
      PlotRange->{{0., 9.999999795918367}, {-3, 3}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {210.9946972606292, -57.159653520352826},
      ImageScaled[{0.5, 0.5}], {124.97783025662427, 108.87553051495776}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwl13c8V98bAPDPsOfH52OTHRlZGRGdR6FhJGWVEDIzKkol9aUyykhWFClK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           "]]},
         Annotation[#, "Charting`Private`Tag$599116#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{10.03061224489796, 1.5}, {17., 20.500000000000014`}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox["\"k(t)\"", TraditionalForm],
      PlotRange->{{0., 9.999999795918367}, {0, 2.4142135482934646`}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {347.2360600602324, -57.159653520352826},
      ImageScaled[{0.5, 0.5}], {127.01864658315489, 108.87553051495776}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwl13k4VN8bAHD7MDMYM2PGvqTIEiqJSudViSKlIgohZClaCClJikRJQoQU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           "]]},
         Annotation[#, "Charting`Private`Tag$599163#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{10.03061224489796, 1.5000000000001137`}, {17., 
       20.500000000000014`}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox["\"j(t)\"", TraditionalForm],
      PlotRange->{{0., 9.999999795918367}, {0, 3.5522845770018234`}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {484.4978310231009, -57.159653520352826},
      ImageScaled[{0.5, 0.5}], {127.018646583155, 108.87553051495776}]}, {}},
  ImageSize->Full,
  PlotRange->{{0, 553.1287165045352}, {-114.31930704070565`, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.743092029247136*^9, 3.7430920388406143`*^9}, 
   3.743092081720955*^9, {3.743092116111912*^9, 3.743092125839719*^9}, 
   3.743092183891129*^9, {3.743092216241065*^9, 3.743092239631466*^9}, {
   3.7430923123947277`*^9, 3.7430923238241034`*^9}, {3.743092483652802*^9, 
   3.743092514528672*^9}, 3.7430926219897203`*^9, 3.743092785249475*^9, 
   3.74309324091866*^9, {3.7430933366124496`*^9, 3.743093382544018*^9}, 
   3.743093432950441*^9, {3.743093618138935*^9, 3.743093637924202*^9}, {
   3.7430940600748672`*^9, 3.743094076428487*^9}, {3.743094115551794*^9, 
   3.7430942160900993`*^9}, {3.743094247142069*^9, 3.743094310697329*^9}, {
   3.743094353377043*^9, 3.743094366313381*^9}, 3.743094949159595*^9, 
   3.7430964989414577`*^9, {3.7430968802942247`*^9, 3.743096904485763*^9}, 
   3.74309699305508*^9, 3.743099440035239*^9, 3.74309959986353*^9, 
   3.743124503920657*^9, 3.74313176696264*^9, 3.743159979768214*^9, 
   3.743160267922073*^9, 3.743160404599783*^9, 3.7431606133305607`*^9, 
   3.743160670762368*^9, 3.7939119827379923`*^9, 3.8232268223281193`*^9},
 CellLabel->
  "Out[1590]=",ExpressionUUID->"b63f4f30-6146-4eb8-ae4a-68d921028054"]
}, Open  ]],

Cell[TextData[{
 "A continuing disturbance causes the gain ",
 StyleBox["k(t)",
  FontSlant->"Italic"],
 " to steadily increase."
}], "Text",
 CellChangeTimes->{{3.743093029669278*^9, 3.7430930531828814`*^9}, {
  3.743093103920197*^9, 3.743093108612818*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"0665da56-f776-4424-babd-bdbbc4d386bd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tend", "=", "100"}], ";", " ", 
   RowBox[{"ad", "=", "1"}], ";", " ", 
   RowBox[{"\[Omega]d", "=", "1"}], ";", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xs1", ",", "us1", ",", "ks1", ",", "js1"}], "}"}], "=", 
    RowBox[{"adapt", "[", 
     RowBox[{
     "\[Gamma]", ",", "x0", ",", "0", ",", "0", ",", "0", ",", "ad", ",", 
      "\[Omega]d"}], "]"}]}], ";", 
   RowBox[{"p5", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"xs1", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<x(t)\>\""}]}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p6", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"us1", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<u(t)\>\""}]}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p7", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"ks1", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "\"\<k(t)\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p8", "=", 
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{"js1", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1000"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<j(t)\>\""}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p5", ",", "p6", ",", "p7", ",", "p8"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.743092641071272*^9, 3.7430926529410877`*^9}, {
  3.74309269570159*^9, 3.7430927282638702`*^9}, {3.7430927599813128`*^9, 
  3.7430927793270063`*^9}, {3.743094380101089*^9, 3.74309451652726*^9}, {
  3.743094558457305*^9, 3.743094567172023*^9}, {3.7430968925629*^9, 
  3.7430968957438097`*^9}, {3.743096961119006*^9, 3.743096973733386*^9}, {
  3.7431317550796747`*^9, 3.743131755190714*^9}, {3.7431601929751587`*^9, 
  3.743160193771243*^9}, {3.743160261966384*^9, 3.743160266059321*^9}, {
  3.743160393729374*^9, 3.7431604224685497`*^9}, {3.743160491283061*^9, 
  3.743160556864402*^9}},
 CellLabel->
  "In[1591]:=",ExpressionUUID->"499adeed-6ccc-4a0e-8677-1e723742071e"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwUV3c41u8XlhEhyd7ZK3vv59hvhUoqVMj+SoVkhZCiEqKQKJVNoSQkjz2y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           "]]},
         Annotation[#, "Charting`Private`Tag$599387#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.17708347257653, 2.6770901562499603`}, {17., 
       22.49999999999997}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox["\"x(t)\"", TraditionalForm],
      PlotRange->{{0., 99.99999795918367}, {-1, 2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {70.70125166936555, -57.19581730731935},
      ImageScaled[{0.5, 0.5}], {131.21759567810514, 108.94441391870353}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwUl3c8198XxxGyoqyQvffe6x5bg5atIiTZFEUlSiWVhJBKlDIilFSUi2T0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           "]]},
         Annotation[#, "Charting`Private`Tag$599433#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{8.010416809311227, 2.5104236562499977`}, {17., 
       22.49999999999997}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox["\"u(t)\"", TraditionalForm],
      PlotRange->{{0., 99.99999795918367}, {-3, 3}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {207.93708842646402, -57.19581730731935},
      ImageScaled[{0.5, 0.5}], {122.88426251483986, 108.94441391870353}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwk13k8VO/bB3DrWIYxM/atsq/Z920+w6CESpu0KYWoLIlUIpRUXyFJKkul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           "]]},
         Annotation[#, "Charting`Private`Tag$599479#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{6.989583476403061, 2.489590343749967}, {17., 
       22.49999999999997}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox["\"k(t)\"", TraditionalForm],
      PlotRange->{{0., 99.99999795918367}, {0, 10}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {340.48542527922575, -57.19581730731935},
      ImageScaled[{0.5, 0.5}], {121.84259586943166, 108.94441391870353}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJws2nc41e//OHDOtMveZe/svV7Pw3HsFQlJZIYkRFKyKtFbSJLMUiRFg0qZ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           "]]},
         Annotation[#, "Charting`Private`Tag$599533#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0.},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({
          Part[#, 1], 
          Exp[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Part[#, 1], 
          Exp[
           Part[#, 2]]}& )},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{18.21875013839286, 2.718756781250022}, {17., 
       22.49999999999997}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None},
      PlotLabel->FormBox["\"j(t)\"", TraditionalForm],
      PlotRange->NCache[{{0., 99.99999795918367}, {0, 
          Log[1000]}}, {{0., 99.99999795918367}, {0, 6.907755278982137}}],
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->FrontEndValueCache[{Automatic, Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }, {
        Automatic, {{0., 
           FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
           FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
           FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
           FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
           FormBox["100", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
           FormBox["500", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
           FormBox["1000", TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.0986122886681098`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.3862943611198906`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.791759469228055, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.9459101490553132`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.0794415416798357`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.1972245773362196`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.995732273553991, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.4011973816621555`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.6888794541139363`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.0943445622221, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.248495242049359, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.382026634673881, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.499809670330265, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.298317366548036, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.703782474656201, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.991464547107982, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.396929655216146, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.551080335043404, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.684611727667927, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.802394763324311, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {7.313220387090301, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {7.600902459542082, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}}}]], {478.2420953590283, -57.19581730731935}, 
     ImageScaled[{0.5, 0.5}], {133.3009289689215, 108.94441391870353}]}, {}},
  ImageSize->Full,
  PlotRange->{{0, 549.9850136738021}, {-114.3916346146387, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.743092713265617*^9, 3.743092729425712*^9}, {
   3.743092783524189*^9, 3.743092787471593*^9}, 3.7430940770466757`*^9, {
   3.74309438089988*^9, 3.7430945195884647`*^9}, {3.743094560785118*^9, 
   3.743094567971822*^9}, 3.743094949605178*^9, 3.743096499399098*^9, {
   3.743096974864645*^9, 3.7430969934962378`*^9}, 3.743099440449205*^9, 
   3.7430996005540743`*^9, 3.7431245044131603`*^9, 3.743131767383009*^9, 
   3.743159980172431*^9, 3.743160194621393*^9, 3.74316027125228*^9, {
   3.743160405076584*^9, 3.74316042362996*^9}, {3.7431604948982077`*^9, 
   3.74316055764402*^9}, 3.743160613839736*^9, 3.7431606717260036`*^9, 
   3.7939119831813383`*^9, 3.823226822715311*^9},
 CellLabel->
  "Out[1595]=",ExpressionUUID->"2e9e0e9d-3b9c-46db-bd26-5d258b8d68c8"]
}, Open  ]],

Cell["\<\
A delay applying feedback causes instability when the gain is too high.\
\>", "Text",
 CellChangeTimes->{{3.743093029669278*^9, 3.7430930531828814`*^9}, {
  3.743093103920197*^9, 3.743093108612818*^9}, {3.743093146717477*^9, 
  3.743093161858994*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"fa2e2f8e-8460-4182-95fd-c9741c6d06be"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"tend", "=", "100"}], ";", " ", 
   RowBox[{"\[Tau]", "=", "0.265"}], ";", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xs2", ",", "us2", ",", "ks2", ",", "js2"}], "}"}], "=", 
    RowBox[{"adapt", "[", 
     RowBox[{
     "\[Gamma]", ",", "x0", ",", "\[Tau]", ",", "0", ",", "0", ",", "ad", ",",
       "\[Omega]d"}], "]"}]}], ";", 
   RowBox[{"p9", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"xs2", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "2"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<x(t)\>\""}]}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p10", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"us2", "[", "t", "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<u(t)\>\""}]}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p11", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"ks2", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "\"\<k(t)\>\""}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p12", "=", 
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{"js2", "[", "t", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1000"}], "}"}]}], ",", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<j(t)\>\""}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p9", ",", "p10", ",", "p11", ",", "p12"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.743094581305418*^9, 3.7430948429559517`*^9}, {
   3.7430948766496572`*^9, 3.743094941411871*^9}, {3.743096508747177*^9, 
   3.7430966435537167`*^9}, {3.743096812366603*^9, 3.743096823594098*^9}, {
   3.743096910204516*^9, 3.743096945928858*^9}, 3.743096988130292*^9, {
   3.743097041395322*^9, 3.743097047028605*^9}, {3.743097117772112*^9, 
   3.743097120367713*^9}, {3.74309718213242*^9, 3.743097343733109*^9}, {
   3.743097385774323*^9, 3.743097509447864*^9}, {3.743097543302516*^9, 
   3.743097624382029*^9}, {3.74315999541234*^9, 3.743160039575049*^9}, {
   3.743160106050395*^9, 3.743160155754594*^9}, {3.743160201464061*^9, 
   3.7431602182311583`*^9}, {3.743160310445012*^9, 3.74316031661714*^9}, {
   3.743160350612462*^9, 3.743160385460644*^9}, {3.743160432064952*^9, 
   3.743160470904364*^9}, {3.743160509089842*^9, 3.743160509412879*^9}, {
   3.743160542088209*^9, 3.743160552571252*^9}},
 CellLabel->
  "In[1596]:=",ExpressionUUID->"68fb36ae-7971-4b61-ae08-ce165c124685"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwUV3c41t8btrIp2SM7Wdl7ncemUKEUKqRIyBYlQgtJCElGKaMhwjfrPVb2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           "]], 
          LineBox[{{98.87775724112697, -1.}, {98.90171439948327, 
           0.5289763951690825}, {98.92099061013924, 2.}}], 
          LineBox[{{98.31287654984922, 2.}, {98.31825125839242, 
           1.956265499935857}, {98.35257261963307, 1.5448316667774662`}, {
           98.38689398087371, 1.0087360394174}, {98.42121534211434, 
           0.36313774657027587`}, {
           98.45553670335497, -0.37043193441678335`}, {
           98.48269539069929, -1.}}], 
          LineBox[{{97.84261481927165, -1.}, {
           97.87207356226415, -0.7497442924611902}, {
           97.90639492350479, -0.4098869906204624}, {
           97.94071628474543, -0.03360046331549249}, {97.97503764598608, 
           0.36517630529145156`}, {98.0093590072267, 0.7710447015844952}, {
           98.04368036846734, 1.1676600084563726`}, {98.07800172970798, 
           1.5380613108192378`}, {98.11232309094862, 1.8648296695777913`}, {
           98.12980554755836, 2.}}], 
          LineBox[{{99.23592749113266, 2.}, {99.24003763684473, -1.}}]},
         Annotation[#, "Charting`Private`Tag$600349#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{16.17708347257653, 2.6770901562499603`}, {17., 
       22.49999999999997}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox["\"x(t)\"", TraditionalForm],
      PlotRange->{{0., 99.99999795918367}, {-1, 2}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {70.70125166936555, -57.19581730731935},
      ImageScaled[{0.5, 0.5}], {131.21759567810514, 108.94441391870353}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwUV3c4F94btYmGrOy9V/b2ua8tIaWMKCrJLEkykoiIUslXQpGUURGhUJ9r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           "]], 
          LineBox[{{96.98408475016575, 3.}, {97.00404419809382, 
           2.616146493262248}, {97.03478983815879, 1.9019450293620161`}, {
           97.06553547822375, 1.0809694916364896`}, {97.09628111828872, 
           0.1731564691603936}, {97.12702675835368, -0.7977059150640714}, {
           97.18851803848361, -2.8149540608737813`}, {
           97.19431284579504, -3.}}], 
          LineBox[{{96.46863334115389, -3.}, {
           96.48136831698946, -2.7622445306432746`}, {
           96.51211395705442, -2.116346801979259}, {
           96.57360523718435, -0.6750272297315055}, {96.60435087724932, 
           0.08194421683342584}, {96.63509651731428, 0.8346394751547506}, {
           96.66584215737925, 1.5603407897977728`}, {96.69658779744421, 
           2.2360812200872124`}, {96.72733343750917, 2.8394862650542505`}, {
           96.73700649988677, 3.}}], 
          LineBox[{{98.17456869009824, 3.}, {98.18096581342988, 
           2.491420396305001}, {98.21528717467052, -0.6291391730982726}, {
           98.23903460287195, -3.}}], 
          LineBox[{{97.59827852476904, -3.}, {
           97.6189569993931, -2.1086575176997924`}, {
           97.64970263945807, -0.6327059102201441}, {97.68044827952303, 
           0.961961846154712}, {97.711193919588, 2.63494491037287}, {
           97.71778841678885, 3.}}], 
          LineBox[{{98.69093569255679, -3.}, {
           98.69578623203944, -1.9788692169933029`}, {98.71365190079787, 
           3.}}], LineBox[{{99.1547286330276, 3.}, {99.15570611998947, -3.}}]},
         Annotation[#, "Charting`Private`Tag$600396#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{8.010416809311227, 2.5104236562499977`}, {17., 
       22.49999999999997}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox["\"u(t)\"", TraditionalForm],
      PlotRange->{{0., 99.99999795918367}, {-3, 3}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {207.93708842646402, -57.19581730731935},
      ImageScaled[{0.5, 0.5}], {122.88426251483986, 108.94441391870353}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJxE13c8FdD/P3B7XtcdZrTslb3XfV2ukSJNI6EiQoVEEommShlJ0k7aQ6Fk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           "]]},
         Annotation[#, "Charting`Private`Tag$600442#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{6.989583476403061, 2.489590343749967}, {17., 
       22.49999999999997}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotLabel->FormBox["\"k(t)\"", TraditionalForm],
      PlotRange->{{0., 99.99999795918367}, {0, 10}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->{Automatic, Automatic}], {340.48542527922575, -57.19581730731935},
      ImageScaled[{0.5, 0.5}], {121.84259586943166, 108.94441391870353}], 
    InsetBox[
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJxE2nc81W/8P36OMzMyS0bJXpW9eT2OczioRBOVipJoqIxIZTRVikqi0KTe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           "]]},
         Annotation[#, "Charting`Private`Tag$600494#1"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0.},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({
          Part[#, 1], 
          Exp[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Part[#, 1], 
          Exp[
           Part[#, 2]]}& )},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
         Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{18.21875013839286, 2.718756781250022}, {17., 
       22.49999999999997}},
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None},
      PlotLabel->FormBox["\"j(t)\"", TraditionalForm],
      PlotRange->NCache[{{0., 99.99999795918367}, {0, 
          Log[1000]}}, {{0., 99.99999795918367}, {0, 6.907755278982137}}],
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}},
      Ticks->FrontEndValueCache[{Automatic, Quiet[
          Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }, {
        Automatic, {{0., 
           FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
           FormBox["5", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
           FormBox["10", TraditionalForm], {0.01, 0.}}, {3.912023005428146, 
           FormBox["50", TraditionalForm], {0.01, 0.}}, {4.605170185988092, 
           FormBox["100", TraditionalForm], {0.01, 0.}}, {6.214608098422191, 
           FormBox["500", TraditionalForm], {0.01, 0.}}, {6.907755278982137, 
           FormBox["1000", TraditionalForm], {0.01, 0.}}, {0.6931471805599453, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.0986122886681098`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.3862943611198906`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.791759469228055, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {1.9459101490553132`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.0794415416798357`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.1972245773362196`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {2.995732273553991, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.4011973816621555`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {3.6888794541139363`, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.0943445622221, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.248495242049359, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.382026634673881, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {4.499809670330265, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.298317366548036, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.703782474656201, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {5.991464547107982, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.396929655216146, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.551080335043404, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.684611727667927, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {6.802394763324311, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {7.313220387090301, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}, {7.600902459542082, 
           FormBox[
            TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
           0.}}}}]], {478.2420953590283, -57.19581730731935}, 
     ImageScaled[{0.5, 0.5}], {133.3009289689215, 108.94441391870353}]}, {}},
  ImageSize->Full,
  PlotRange->{{0, 549.9850136738021}, {-114.3916346146387, 0}},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.743094619304483*^9, 3.743094843872655*^9}, {
   3.743094884125651*^9, 3.7430949500780897`*^9}, {3.74309649988907*^9, 
   3.7430966450049458`*^9}, 3.743096826701714*^9, {3.743096925455749*^9, 
   3.74309694706247*^9}, 3.743096994150177*^9, 3.743097048672777*^9, 
   3.7430971229913054`*^9, {3.743097183709412*^9, 3.743097344694133*^9}, {
   3.743097387485106*^9, 3.743097510206753*^9}, {3.7430975461487217`*^9, 
   3.74309762515067*^9}, 3.7430994409237967`*^9, 3.7430996012184963`*^9, 
   3.743124504908777*^9, 3.743131768437086*^9, {3.743159980736474*^9, 
   3.7431600403490887`*^9}, {3.74316010794468*^9, 3.7431601568668737`*^9}, {
   3.743160202455151*^9, 3.743160219171172*^9}, 3.743160317829383*^9, {
   3.7431603516622057`*^9, 3.7431604725286283`*^9}, 3.7431605109704027`*^9, {
   3.743160549140286*^9, 3.743160553886607*^9}, 3.743160615057437*^9, 
   3.7431606729782753`*^9, 3.7939119840394363`*^9, 3.8232268235016212`*^9},
 CellLabel->
  "Out[1600]=",ExpressionUUID->"3c14afd4-8291-4aab-bf9f-f2f3118511dc"]
}, Open  ]],

Cell["Export data", "Text",
 CellChangeTimes->{{3.743093029669278*^9, 3.7430930531828814`*^9}, {
  3.743093103920197*^9, 3.743093108612818*^9}, {3.743093146717477*^9, 
  3.743093161858994*^9}, {3.743097016898711*^9, 3.7430970197685747`*^9}, {
  3.793911954067933*^9, 3.793911955290165*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"55863b86-1a1b-4e0d-8b3f-e6267fcef9a2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dt", "=", "0.1"}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tend", "=", "10"}], ";", "         ", 
  RowBox[{"dat1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Through", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xs", ",", "us", ",", "ks", ",", "js"}], "}"}], "[", "t", 
       "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend", ",", "dt"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tend", "=", "100"}], ";", "       ", 
  RowBox[{"dat2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Through", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xs1", ",", "us1", ",", "ks1", ",", "js1"}], "}"}], "[", "t", 
       "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend", ",", "dt"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tend", "=", "99.3"}], ";", "     ", 
  RowBox[{"dat3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Through", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xs2", ",", "us2", ",", "ks2", ",", "js2"}], "}"}], "[", "t", 
       "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "tend", ",", "dt"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<unstableAdapt1a.dat\>\"", ",", "dat1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<unstableAdapt1b.dat\>\"", ",", "dat2"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<unstableAdapt1c.dat\>\"", ",", "dat3"}], "]"}], ";"}], " ", 
   "\[IndentingNewLine]", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.743097783371628*^9, 3.743097785897781*^9}, {
  3.743099245775935*^9, 3.743099351316478*^9}, {3.743099414397357*^9, 
  3.743099435343521*^9}, {3.7430994826136923`*^9, 3.743099484575018*^9}, {
  3.743099677710437*^9, 3.7430997056000233`*^9}, {3.7430999053015957`*^9, 
  3.743099936389556*^9}, {3.743124472726253*^9, 3.7431244947413054`*^9}, {
  3.743124531943714*^9, 3.743124594265078*^9}, {3.7431317621009903`*^9, 
  3.7431317621698437`*^9}, {3.743160679088509*^9, 3.7431606888443317`*^9}, {
  3.743161048318507*^9, 3.743161199574403*^9}, {3.7939119584493027`*^9, 
  3.793911977186593*^9}},
 CellLabel->
  "In[1601]:=",ExpressionUUID->"e67f2595-3978-429f-a2e0-32c96f4cf52d"],

Cell["\<\
Addendum:  How does the asymptotic value of j depend on k0?  (It\
\[CloseCurlyQuote]s complicated; no clear trends.)\
\>", "Text",
 CellChangeTimes->{{3.743093029669278*^9, 3.7430930531828814`*^9}, {
  3.743093103920197*^9, 3.743093108612818*^9}, {3.743093146717477*^9, 
  3.743093161858994*^9}, {3.743095086284739*^9, 3.743095104570529*^9}, {
  3.743096484929041*^9, 3.74309649315077*^9}, {3.743097004522779*^9, 
  3.7430970077450933`*^9}},
 Background->GrayLevel[
  0.85],ExpressionUUID->"59ba1e30-986a-400a-afbe-29044c905431"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"adapt1", "[", 
    RowBox[{
    "\[Gamma]_", ",", "x0_", ",", "\[Tau]_", ",", "k0_", ",", "\[Alpha]_", 
     ",", "ad_", ",", "\[Omega]d_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "eqs", ",", "init", ",", "pars", ",", "x", ",", "t", ",", "a", ",", "u",
        ",", "j", ",", "k", ",", "xs", ",", "ks", ",", "us", ",", "js"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"eqs", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"x", "'"}], "[", "t", "]"}], "-", " ", 
           RowBox[{"a", " ", 
            RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", 
          RowBox[{
           RowBox[{"u", "[", "t", "]"}], "+", 
           RowBox[{"ad", " ", 
            RowBox[{"UnitStep", "[", "t", "]"}], " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"\[Omega]d", " ", "t"}], "]"}]}]}]}], ",", 
         RowBox[{
          RowBox[{"u", "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"k", "[", "t", "]"}]}], 
           RowBox[{"x", "[", 
            RowBox[{"t", "-", "\[Tau]"}], "]"}]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"k", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"\[Gamma]", " ", 
            SuperscriptBox[
             RowBox[{"x", "[", "t", "]"}], "2"]}], "-", 
           RowBox[{"\[Alpha]", " ", 
            RowBox[{"k", "[", "t", "]"}]}]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"j", "'"}], "[", "t", "]"}], "\[Equal]", 
          RowBox[{
           FractionBox["1", "2"], 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"x", "[", "t", "]"}], "2"], "+", 
             SuperscriptBox[
              RowBox[{"u", "[", "t", "]"}], "2"]}], ")"}]}]}]}], "}"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"init", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", 
           RowBox[{"t", " ", "/;", " ", 
            RowBox[{"t", " ", "\[LessEqual]", " ", "0"}]}], "]"}], "\[Equal]",
           "x0"}], " ", ",", 
         RowBox[{
          RowBox[{"k", "[", 
           RowBox[{"t", " ", "/;", " ", 
            RowBox[{"t", " ", "\[LessEqual]", " ", "0"}]}], "]"}], "\[Equal]",
           "k0"}], ",", 
         RowBox[{
          RowBox[{"j", "[", "0", " ", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"t", " ", "/;", " ", 
            RowBox[{"t", " ", "\[LessEqual]", " ", "0"}]}], "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"k", "[", 
             RowBox[{"t", " ", "/;", " ", 
              RowBox[{"t", " ", "\[LessEqual]", " ", "0"}]}], "]"}]}], 
           RowBox[{"x", "[", 
            RowBox[{"t", " ", "/;", " ", 
             RowBox[{"t", " ", "\[LessEqual]", " ", "0"}]}], "]"}]}]}]}], 
        "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xs", ",", "ks", ",", "us", ",", "js"}], "}"}], "=", 
       RowBox[{
        RowBox[{"NDSolveValue", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"eqs", ",", "init"}], "}"}], "/.", 
           RowBox[{"a", "\[Rule]", "1"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"x", ",", "u", ",", "k", ",", "j"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "tend"}], "}"}], ",", 
          RowBox[{"MaxSteps", "\[Rule]", 
           SuperscriptBox["10", "5"]}]}], 
         StyleBox["]",
          FontSize->12]}], 
        StyleBox["//",
         FontSize->12], 
        StyleBox["Quiet",
         FontSize->12]}]}], 
      StyleBox[";",
       FontSize->12], 
      StyleBox[
       RowBox[{"js", "[", "tend", "]"}],
       FontSize->12]}]}], 
    StyleBox["]",
     FontSize->12]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tend", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"adapt1", "[", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "k0", ",", "0", ",", "0", ",", "5"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"k0", ",", "1.5", ",", "3"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "1"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "10"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.743095131349203*^9, 3.7430953172604847`*^9}, {
  3.7430964392650013`*^9, 3.7430964741600237`*^9}},
 CellLabel->
  "In[1605]:=",ExpressionUUID->"dc914e39-57c1-46fb-9136-74d3e3cefe54"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAAj+9LAAA+D/mMb9uMEj1P2K2kdZL
SPk/z6yZwKvQ9D/BLWaAl5D6P8iuJcT4bfQ/SFicdoD0+z/LwYJHyRf0P86C
0mxpWP0/SuSgbqLU8z9ILTd8vKT+P/Yrv/L9pPM/wtebiw/x/z+DJw8pHoLz
P6AJoOJumwBAkQSQLNtq8z9gJ3L/VT4BQGijLZ8lXfM/sx51wgvvAUC+ASoX
zVfzPwYWeIXBnwJADQHmCi9b8z9TTRJVrEQDQOGYKpRIZfM/oISsJJfpA0CU
bv81U3XzP4CVd5pQnARAKHioB6yM8z9hpkIQCk8FQFfPcsKGqfM/xH8tG4H+
BUAfqM3GncrzPydZGCb4rQZARjVCw+nv8z/T3NwH/FYHQK9mhKlnF/Q/f2Ch
6f//B0Anr8rBC0L0P2srlBY=
       "]]},
     Annotation[#, "Charting`Private`Tag$601286#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{1.5000001666666667`, 1.2089358239028196`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.74309518001071*^9, {3.743095237405141*^9, 3.743095255530181*^9}, {
   3.743095297955489*^9, 3.743095317945623*^9}, {3.743096440026178*^9, 
   3.743096500287656*^9}, 3.743096994763741*^9, 3.743099441779509*^9, 
   3.743099601985383*^9, 3.74312450674966*^9, 3.743131769044796*^9, 
   3.743159981490807*^9, 3.7431604059806547`*^9, 3.743160615971483*^9, 
   3.743160673451586*^9, 3.793911984290888*^9, 3.8232268238344097`*^9},
 CellLabel->
  "Out[1607]=",ExpressionUUID->"4c0df124-005c-4b52-8ec2-0b69109982de"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 282}, {Automatic, 0}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"eeffa295-ce0b-488c-9eed-d352e517ce03"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 374, 5, 67, "Section",ExpressionUUID->"604c3724-e633-4cc6-b5f4-3295cb90fe06"],
Cell[957, 29, 467, 10, 29, "Input",ExpressionUUID->"caf69fce-de33-4573-a446-2f26e494af5b"],
Cell[1427, 41, 6100, 140, 216, "Input",ExpressionUUID->"741900a0-4539-4cfe-80d4-02beba69b755"],
Cell[7530, 183, 304, 8, 51, "Text",ExpressionUUID->"c1be2ade-6158-4e4b-9335-f68d2d37c9ed"],
Cell[CellGroupData[{
Cell[7859, 195, 3027, 80, 178, "Input",ExpressionUUID->"5d075a28-8aba-47de-86ac-a3ab2226b805"],
Cell[10889, 277, 55993, 975, 168, "Output",ExpressionUUID->"b63f4f30-6146-4eb8-ae4a-68d921028054"]
}, Open  ]],
Cell[66897, 1255, 346, 9, 51, "Text",ExpressionUUID->"0665da56-f776-4424-babd-bdbbc4d386bd"],
Cell[CellGroupData[{
Cell[67268, 1268, 3009, 79, 178, "Input",ExpressionUUID->"499adeed-6ccc-4a0e-8677-1e723742071e"],
Cell[70280, 1349, 192244, 3230, 169, "Output",ExpressionUUID->"2e9e0e9d-3b9c-46db-bd26-5d258b8d68c8"]
}, Open  ]],
Cell[262539, 4582, 349, 7, 51, "Text",ExpressionUUID->"fa2e2f8e-8460-4182-95fd-c9741c6d06be"],
Cell[CellGroupData[{
Cell[262913, 4593, 3324, 83, 178, "Input",ExpressionUUID->"68fb36ae-7971-4b61-ae08-ce165c124685"],
Cell[266240, 4678, 195200, 3276, 169, "Output",ExpressionUUID->"3c14afd4-8291-4aab-bf9f-f2f3118511dc"]
}, Open  ]],
Cell[461455, 7957, 378, 6, 51, "Text",ExpressionUUID->"55863b86-1a1b-4e0d-8b3f-e6267fcef9a2"],
Cell[461836, 7965, 2654, 68, 220, "Input",ExpressionUUID->"e67f2595-3978-429f-a2e0-32c96f4cf52d"],
Cell[464493, 8035, 539, 10, 51, "Text",ExpressionUUID->"59ba1e30-986a-400a-afbe-29044c905431"],
Cell[CellGroupData[{
Cell[465057, 8049, 4740, 130, 300, "Input",ExpressionUUID->"dc914e39-57c1-46fb-9136-74d3e3cefe54"],
Cell[469800, 8181, 2615, 62, 259, "Output",ExpressionUUID->"4c0df124-005c-4b52-8ec2-0b69109982de"]
}, Open  ]]
}, Open  ]]
}
]
*)

