(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     10563,        291]
NotebookOptionsPosition[      9200,        258]
NotebookOutlinePosition[      9598,        274]
CellTagsIndexPosition[      9555,        271]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Illustrate Jensen\[CloseCurlyQuote]s inequality for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SuperscriptBox["x", "2"]}], TraditionalForm]],ExpressionUUID->
  "addce69e-45a5-419a-97ed-ddc354df93ff"],
 "  (Section A.6.5)"
}], "Section",
 CellChangeTimes->{{3.606157441543578*^9, 3.606157456277753*^9}, {
  3.7940009854233418`*^9, 
  3.794000989610264*^9}},ExpressionUUID->"5201f1f0-5fc6-445a-9aba-\
554d4a07aede"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[ScriptCapitalD]y", "=", 
  RowBox[{"TransformedDistribution", "[", 
   RowBox[{
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"x", "\[Distributed]", 
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"\[Mu]", ",", "1"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.606156118982045*^9, 3.606156153198338*^9}, {
  3.606157467553925*^9, 3.606157481659267*^9}},
 CellLabel->
  "In[2360]:=",ExpressionUUID->"e5be26ec-122b-4a54-91d8-037e0dbaa0af"],

Cell[BoxData[
 RowBox[{"NoncentralChiSquareDistribution", "[", 
  RowBox[{"1", ",", 
   SuperscriptBox["\[Mu]", "2"]}], "]"}]], "Output",
 CellChangeTimes->{{3.60615613216674*^9, 3.606156154039693*^9}, 
   3.606157483067815*^9, 3.614883283119254*^9, 3.794000626049407*^9, 
   3.794000913183124*^9, 3.823228451395154*^9},
 CellLabel->
  "Out[2360]=",ExpressionUUID->"627ef554-0145-495a-a839-3226cfdf6763"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{"\[ScriptCapitalD]y", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{3.606157489182805*^9},
 CellLabel->
  "In[2361]:=",ExpressionUUID->"5ea8e65e-44e2-4004-b431-cfc7a8f8d589"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "x"}], "-", 
              SuperscriptBox["\[Mu]", "2"]}], ")"}]}]], " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{
            SqrtBox["x"], " ", "\[Mu]"}], "]"}]}], 
         RowBox[{
          SqrtBox[
           RowBox[{"2", " ", "\[Pi]"}]], " ", 
          SqrtBox["x"]}]], 
        RowBox[{"x", ">", "0"}]},
       {"0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "Output",
 CellChangeTimes->{{3.606156144664071*^9, 3.606156156680338*^9}, 
   3.606157490510454*^9, 3.6148832834739237`*^9, 3.794000626156225*^9, 
   3.794000913236672*^9, 3.823228451572791*^9},
 CellLabel->
  "Out[2361]=",ExpressionUUID->"99aa6746-8efa-4b16-bdcf-993a72471620"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"LogLogPlot", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"\[ScriptCapitalD]y", "/.", 
        RowBox[{"\[Mu]", "\[Rule]", "\[Mu]0"}]}], ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.01", ",", "1000"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "11"}]], ",", "10"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Mu]0", ",", "4"}], "}"}], ",", "0", ",", "20", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6061561857308187`*^9, 3.606156318127249*^9}, {
   3.6061563528287067`*^9, 3.606156391723494*^9}, {3.6061570794091463`*^9, 
   3.606157084175954*^9}, 3.6061574973045464`*^9, {3.6061577192947283`*^9, 
   3.606157770174036*^9}, 3.614883286709344*^9, {3.79400064918746*^9, 
   3.7940008840770283`*^9}},
 CellLabel->
  "In[2362]:=",ExpressionUUID->"626dc8bc-6838-4524-b6cd-4cab3cf6ebec"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Mu]0$$ = 5.550000000000001, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Mu]0$$], 4}, 0, 20}}, Typeset`size$$ = {
    360., {109., 113.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Mu]0$$ = 4}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> LogLogPlot[
        PDF[
         ReplaceAll[$CellContext`\[ScriptCapitalD]y, $CellContext`\[Mu] -> \
$CellContext`\[Mu]0$$], $CellContext`x], {$CellContext`x, 0.01, 1000}, 
        Filling -> Axis, PlotRange -> {10^(-11), 10}], 
      "Specifications" :> {{{$CellContext`\[Mu]0$$, 4}, 0, 20, Appearance -> 
         "Open"}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {167., 173.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.606156177682694*^9, 3.606156264596403*^9}, 
   3.606156320614752*^9, {3.606156362862321*^9, 3.606156392759804*^9}, 
   3.606157084972233*^9, 3.606157497841374*^9, 3.606157721039322*^9, {
   3.6061577614966288`*^9, 3.60615777056423*^9}, {3.614883283598246*^9, 
   3.614883311809733*^9}, {3.79400062620678*^9, 3.7940006681171427`*^9}, {
   3.794000703759673*^9, 3.794000775717902*^9}, {3.794000810468439*^9, 
   3.794000913248728*^9}, 3.8232284516177263`*^9},
 CellLabel->
  "Out[2362]=",ExpressionUUID->"05bb4ae3-53a1-474b-9ae5-bce6e09e544a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Mean", "[", 
     RowBox[{"\[ScriptCapitalD]y", "/.", 
      RowBox[{"\[Mu]", "\[Rule]", "3"}]}], "]"}], "//", "N"}], ",", 
   RowBox[{
    RowBox[{"Variance", "[", 
     RowBox[{"\[ScriptCapitalD]y", "/.", 
      RowBox[{"\[Mu]", "\[Rule]", "3"}]}], "]"}], "//", "N"}]}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.606157113050891*^9, 3.6061571374252243`*^9}, 
   3.606157308289282*^9, {3.6061575074970922`*^9, 3.606157522497231*^9}},
 CellLabel->
  "In[2363]:=",ExpressionUUID->"a07c413d-c0fe-4618-91ec-a0bdb214e3f6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.`", ",", "38.`"}], "}"}]], "Output",
 CellChangeTimes->{{3.6061571171904087`*^9, 3.6061571377415657`*^9}, 
   3.6061573092834883`*^9, {3.606157508119104*^9, 3.606157522951975*^9}, 
   3.6148832836404943`*^9, 3.794000626291202*^9, 3.794000913465892*^9, 
   3.823228451785425*^9},
 CellLabel->
  "Out[2363]=",ExpressionUUID->"738e9bea-cbfd-4260-a4af-7189dfe208d9"]
}, Open  ]],

Cell[TextData[{
 "Note that the mean > ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Mu]", "2"], "=", "9"}], ",", " ", 
    RowBox[{
    "in", " ", "accordance", " ", "with", " ", "the", " ", "Jensen", " ", 
     "inequality"}]}], TraditionalForm]],ExpressionUUID->
  "3d29999b-233c-4a00-a210-9f8ae33f97a2"]
}], "Text",
 CellChangeTimes->{{3.6061584289766827`*^9, 
  3.606158462807433*^9}},ExpressionUUID->"7553143f-63fe-4d6a-8f4a-\
9803fb6a4def"]
}, Open  ]]
},
WindowSize->{740, 752},
WindowMargins->{{Automatic, 146}, {65, Automatic}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"40b8d336-095f-4697-983b-80ebd20e1570"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 443, 12, 68, "Section",ExpressionUUID->"5201f1f0-5fc6-445a-9aba-554d4a07aede"],
Cell[CellGroupData[{
Cell[1047, 38, 481, 11, 30, "Input",ExpressionUUID->"e5be26ec-122b-4a54-91d8-037e0dbaa0af"],
Cell[1531, 51, 404, 8, 37, "Output",ExpressionUUID->"627ef554-0145-495a-a839-3226cfdf6763"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1972, 64, 222, 5, 30, "Input",ExpressionUUID->"5ea8e65e-44e2-4004-b431-cfc7a8f8d589"],
Cell[2197, 71, 1969, 58, 73, "Output",ExpressionUUID->"99aa6746-8efa-4b16-bdcf-993a72471620"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4203, 134, 1193, 29, 79, "Input",ExpressionUUID->"626dc8bc-6838-4524-b6cd-4cab3cf6ebec"],
Cell[5399, 165, 2264, 43, 359, "Output",ExpressionUUID->"05bb4ae3-53a1-474b-9ae5-bce6e09e544a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7700, 213, 583, 15, 30, "Input",ExpressionUUID->"a07c413d-c0fe-4618-91ec-a0bdb214e3f6"],
Cell[8286, 230, 405, 8, 34, "Output",ExpressionUUID->"738e9bea-cbfd-4260-a4af-7189dfe208d9"]
}, Open  ]],
Cell[8706, 241, 478, 14, 35, "Text",ExpressionUUID->"7553143f-63fe-4d6a-8f4a-9803fb6a4def"]
}, Open  ]]
}
]
*)

